/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.information;

import com.jrockit.mc.components.ui.base.AbstractUIConfigurer;
import com.jrockit.mc.components.ui.settings.CompositeInput;
import com.jrockit.mc.components.ui.settings.IInput;
import com.jrockit.mc.components.ui.settings.InputControl;
import com.jrockit.mc.components.ui.settings.TabFolderInput;
import com.jrockit.mc.flightrecorder.ui.components.information.AttributeInput;
import com.jrockit.mc.flightrecorder.ui.components.information.InformationDescriptorRepository;
import com.jrockit.mc.flightrecorder.ui.components.inputs.InputFactory;
import com.jrockit.mc.flightrecorder.ui.components.inputs.Role;
import com.jrockit.mc.flightrecorder.ui.components.selection.EventTypeDescriptorRepository;
import com.jrockit.mc.flightrecorder.ui.messages.internal.Messages;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public final class InformationConfigurer
extends AbstractUIConfigurer {
    private static final String INFORMATION_DESCRIPTOR_REPOSITORY = "informationDescriptorRepository";
    static final String INFORMATION_DESCRIPTORS = "InformationDescriptors";

    public final Control createPart(Composite parent) {
        return new InputControl(parent, this.getStatusProvider(), (Object)this.getInformationDescriptorRepository(), this.createInput());
    }

    private IInput createInput() {
        TabFolderInput folder = new TabFolderInput();
        folder.addInput(this.createGeneralInput());
        folder.addInput(this.createInformationListInput());
        return folder;
    }

    private IInput createInformationListInput() {
        AttributeInput ai = new AttributeInput(this.getServiceLocator(), this.getInformationDescriptorRepository());
        ai.addInput(InputFactory.createAttributeWithRepository(this.getServiceLocator(), this.getEventTypeRepository(), true));
        ai.addInput((IInput)InputFactory.createName().setAllowEmpty(false));
        ai.addInput(InputFactory.createDescription());
        ai.addInput(InputFactory.createAggregator());
        ai.addInput(InputFactory.createCaption());
        ai.addInput(InputFactory.createUnit(true));
        return ai;
    }

    private EventTypeDescriptorRepository getEventTypeRepository() {
        return this.getInformationDescriptorRepository().getEventTypeDescriptorRepository();
    }

    public IInput createGeneralInput() {
        CompositeInput input = new CompositeInput(Messages.COMPONENT_GENERAL_TITLE);
        input.addInput(InputFactory.createRole(Role.INDEPENDENT, Role.SLAVE));
        input.addInput(InputFactory.createExpandedRange());
        return input;
    }

    private InformationDescriptorRepository getInformationDescriptorRepository() {
        return (InformationDescriptorRepository)this.getComponentSettings().getChildObject(INFORMATION_DESCRIPTOR_REPOSITORY, InformationDescriptorRepository.class);
    }
}

