/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.applemenu;

import com.apple.eawt.Application;
import com.apple.eawt.ApplicationEvent;
import com.apple.eawt.ApplicationListener;
import com.apple.eawt.FullScreenUtilities;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.beans.Beans;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JDialog;
import org.openide.ErrorManager;
import org.openide.awt.Actions;
import org.openide.cookies.EditCookie;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.ViewCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.windows.WindowManager;
import org.openide.windows.WindowSystemEvent;
import org.openide.windows.WindowSystemListener;

class NbApplicationAdapter
implements ApplicationListener {
    private static ApplicationListener al = null;

    private NbApplicationAdapter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void install() {
        boolean bl = Beans.isDesignTime();
        try {
            Beans.setDesignTime(false);
            al = new NbApplicationAdapter();
            Application.getApplication().addApplicationListener(al);
            Application.getApplication().setEnabledAboutMenu(true);
            Application.getApplication().setEnabledPreferencesMenu(true);
        }
        finally {
            Beans.setDesignTime(bl);
        }
        WindowManager.getDefault().addWindowSystemListener(new WindowSystemListener(){

            public void beforeLoad(WindowSystemEvent windowSystemEvent) {
                WindowManager.getDefault().removeWindowSystemListener((WindowSystemListener)this);
                try {
                    FullScreenUtilities.setWindowCanFullScreen((Window)WindowManager.getDefault().getMainWindow(), (boolean)true);
                }
                catch (ThreadDeath threadDeath) {
                    throw threadDeath;
                }
                catch (Throwable throwable) {
                    Logger.getLogger(NbApplicationAdapter.class.getName()).log(Level.FINE, "Error while setting up full screen support.", throwable);
                }
            }

            public void afterLoad(WindowSystemEvent windowSystemEvent) {
            }

            public void beforeSave(WindowSystemEvent windowSystemEvent) {
            }

            public void afterSave(WindowSystemEvent windowSystemEvent) {
            }
        });
    }

    static void uninstall() {
        if (al != null) {
            Application.getApplication().removeApplicationListener(al);
            al = null;
        }
    }

    public void handleAbout(ApplicationEvent applicationEvent) {
        Window[] windowArray = Dialog.getWindows();
        if (null != windowArray) {
            for (Window window : windowArray) {
                JDialog jDialog;
                if (!(window instanceof JDialog) || !Boolean.TRUE.equals((jDialog = (JDialog)window).getRootPane().getClientProperty("nb.about.dialog")) || !jDialog.isVisible()) continue;
                jDialog.toFront();
                applicationEvent.setHandled(true);
                return;
            }
        }
        applicationEvent.setHandled(this.performAction("Help", "org.netbeans.core.actions.AboutAction"));
    }

    public void handleOpenApplication(ApplicationEvent applicationEvent) {
    }

    public void handleOpenFile(ApplicationEvent applicationEvent) {
        FileObject fileObject;
        boolean bl = false;
        String string = applicationEvent.getFilename();
        File file = new File(string);
        if (file.exists() && !file.isDirectory() && (fileObject = FileUtil.toFileObject((File)file)) != null) {
            try {
                DataObject dataObject = DataObject.find((FileObject)fileObject);
                OpenCookie openCookie = (OpenCookie)dataObject.getLookup().lookup(OpenCookie.class);
                bl = openCookie != null;
                if (bl) {
                    openCookie.open();
                } else {
                    EditCookie editCookie = (EditCookie)dataObject.getLookup().lookup(EditCookie.class);
                    bl = editCookie != null;
                    if (bl) {
                        editCookie.edit();
                    } else {
                        ViewCookie viewCookie = (ViewCookie)dataObject.getLookup().lookup(ViewCookie.class);
                        bl = viewCookie != null;
                        if (bl) {
                            viewCookie.view();
                        }
                    }
                }
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                Logger.getLogger(NbApplicationAdapter.class.getName()).log(Level.INFO, string, dataObjectNotFoundException);
            }
        }
        applicationEvent.setHandled(bl);
    }

    public void handlePreferences(ApplicationEvent applicationEvent) {
        applicationEvent.setHandled(this.performAction("Window", "org.netbeans.modules.options.OptionsWindowAction"));
    }

    public void handlePrintFile(ApplicationEvent applicationEvent) {
    }

    public void handleQuit(ApplicationEvent applicationEvent) {
        applicationEvent.setHandled(!this.performAction("System", "org.netbeans.core.actions.SystemExit"));
    }

    public void handleReOpenApplication(ApplicationEvent applicationEvent) {
    }

    private boolean performAction(String string, String string2) {
        Action action = Actions.forID((String)string, (String)string2);
        if (action == null) {
            return false;
        }
        ActionEvent actionEvent = new ActionEvent(this, 1001, "whatever");
        try {
            action.actionPerformed(actionEvent);
            return true;
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify(16, (Throwable)exception);
            return false;
        }
    }
}

