/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rcp.application.scripting;

import com.jrockit.mc.commands.CommandsPlugin;
import com.jrockit.mc.commands.Statement;
import com.jrockit.mc.commands.Value;
import com.jrockit.mc.rcp.application.scripting.model.OperatingSystem;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.custom.LineStyleEvent;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Control;

final class ScriptLineStyleListener
implements LineStyleListener {
    private final Font m_font;
    private final Color m_red;
    private final Color m_green;
    private final Color m_white;
    private final Color m_black;
    private final Color m_commandColor;
    private final Font m_boldFont;
    private final Color m_stringColor;

    public ScriptLineStyleListener(Control control, OperatingSystem os) {
        this.m_font = new Font((Device)control.getDisplay(), "Courier New", 10, 0);
        this.m_boldFont = new Font((Device)control.getDisplay(), "Courier New", 10, 1);
        this.m_commandColor = new Color((Device)control.getDisplay(), 127, 0, 85);
        this.m_red = new Color((Device)control.getDisplay(), 255, 0, 0);
        this.m_black = new Color((Device)control.getDisplay(), 0, 0, 0);
        this.m_white = new Color((Device)control.getDisplay(), 255, 255, 255);
        this.m_green = new Color((Device)control.getDisplay(), 63, 127, 95);
        this.m_stringColor = new Color((Device)control.getDisplay(), 42, 0, 255);
        this.addResourceDisposer(control, new Resource[]{this.m_font, this.m_red, this.m_black, this.m_white, this.m_green, this.m_commandColor, this.m_boldFont, this.m_stringColor});
    }

    private void addResourceDisposer(Control control, final Resource ... resources) {
        control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Resource[] resourceArray = resources;
                int n = resources.length;
                int n2 = 0;
                while (n2 < n) {
                    Resource resource = resourceArray[n2];
                    resource.dispose();
                    ++n2;
                }
            }
        });
    }

    public void lineGetStyle(LineStyleEvent event) {
        StyledText s = (StyledText)event.widget;
        String text = event.lineText;
        event.styles = this.processLine(event.lineOffset, text, s.getLineAtOffset(event.lineOffset));
    }

    private StyleRange[] processLine(int lineOffset, String text, int lineNumber) {
        try {
            List stats = CommandsPlugin.getDefault().parse(text);
            if (stats.isEmpty()) {
                return this.createCommentStyle(lineOffset, text.length());
            }
            return this.createOKStyle((Statement)stats.get(0), text, lineOffset, text.length());
        }
        catch (ParseException pe) {
            return this.createCompileError(lineOffset, pe.getErrorOffset(), text.length());
        }
    }

    private StyleRange[] createCommentStyle(int offset, int length) {
        StyleRange style = new StyleRange(offset, offset + length, this.m_green, this.m_white);
        style.font = this.m_font;
        return new StyleRange[]{style};
    }

    private StyleRange[] createCompileError(int offset, int errorOffset, int length) {
        StyleRange style = new StyleRange(offset + errorOffset, length - errorOffset, this.m_black, this.m_white);
        style.underline = true;
        style.underlineStyle = 3;
        style.underlineColor = this.m_red;
        style.font = this.m_font;
        return new StyleRange[]{style};
    }

    private StyleRange[] createOKStyle(Statement statement, String text, int offset, int length) {
        ArrayList<StyleRange> srs = new ArrayList<StyleRange>();
        srs.add(this.createCommandStyle(statement, text, offset));
        Value lastValue = null;
        for (Value current : statement.getValues()) {
            if (lastValue != null) {
                srs.add(this.createParameterStyle(current, lastValue.getPosition() + offset, current.getPosition() - lastValue.getPosition()));
            }
            lastValue = current;
        }
        if (lastValue != null) {
            srs.add(this.createParameterStyle(lastValue, lastValue.getPosition() + offset, text.length() - lastValue.getPosition()));
        }
        return srs.toArray(new StyleRange[srs.size()]);
    }

    private StyleRange createCommandStyle(Statement statement, String text, int offset) {
        String keyword = statement.getCommand().getIdentifier();
        int commandStart = offset + text.indexOf(keyword);
        StyleRange commandStyle = new StyleRange(commandStart, keyword.length(), this.m_black, this.m_white);
        commandStyle.font = this.m_font;
        return commandStyle;
    }

    private StyleRange createParameterStyle(Value v, int start, int length) {
        StyleRange parameterStyle = new StyleRange();
        parameterStyle.start = start;
        parameterStyle.length = length;
        parameterStyle.background = this.m_white;
        String type = v.getParameter().getType();
        if (type.equals("string")) {
            parameterStyle.foreground = this.m_stringColor;
            parameterStyle.font = this.m_font;
        }
        if (type.equals("boolean")) {
            parameterStyle.foreground = this.m_commandColor;
            parameterStyle.font = this.m_boldFont;
        }
        if (type.equals("number")) {
            parameterStyle.foreground = this.m_black;
            parameterStyle.font = this.m_font;
        }
        return parameterStyle;
    }
}

