/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.components.ui.design.menus;

import com.jrockit.mc.components.ui.components.ComponentDescriptor;
import com.jrockit.mc.components.ui.design.LayoutItem;
import com.jrockit.mc.components.ui.design.LayoutNotifaction;
import com.jrockit.mc.components.ui.design.LayoutToolkit;
import com.jrockit.mc.components.ui.design.OperationType;
import com.jrockit.mc.components.ui.design.actions.ComponentPropertiesAction;
import com.jrockit.mc.components.ui.design.actions.CopyAction;
import com.jrockit.mc.components.ui.design.actions.CutAction;
import com.jrockit.mc.components.ui.design.actions.ExportAction;
import com.jrockit.mc.components.ui.design.actions.ImportAction;
import com.jrockit.mc.components.ui.design.actions.InsertAction;
import com.jrockit.mc.components.ui.design.actions.PasteAction;
import com.jrockit.mc.components.ui.design.actions.RemoveAction;
import com.jrockit.mc.components.ui.design.designelement.IDesignElement;
import com.jrockit.mc.components.ui.design.menus.AssignComponentMenu;
import com.jrockit.mc.components.ui.design.menus.BaseMenu;
import com.jrockit.mc.components.ui.messages.internal.Messages;
import com.jrockit.mc.components.ui.services.IServiceLocator;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;

public final class DesignMenu
extends BaseMenu {
    public DesignMenu(IDesignElement element, IServiceLocator locator) {
        super(Messages.DESIGN_MENU_DESIGN_MENU_TEXT, element, locator);
    }

    @Override
    protected void populateMenu(IMenuManager manager) {
        this.addAssignCompomentMenu(manager);
        this.addLayoutItems(manager);
        this.addClipboardItems(manager);
        this.addImportExport(manager);
        if (this.hasComponentDescriptor()) {
            this.addProperties(manager);
        }
    }

    private void addClipboardItems(IMenuManager manager) {
        this.addCut(manager);
        this.addCopy(manager);
        this.addPaste(manager);
        this.addSeparator(manager);
    }

    private void addCut(IMenuManager manager) {
        manager.add((IAction)new CutAction(this.getDesignElement()));
    }

    private void addCopy(IMenuManager manager) {
        manager.add((IAction)new CopyAction(this.getDesignElement()));
    }

    private void addPaste(IMenuManager manager) {
        manager.add((IAction)new PasteAction(this.getDesignElement()));
    }

    private void addImportExport(IMenuManager manager) {
        this.addImport(manager);
        if (this.hasComponentDescriptor()) {
            this.addExport(manager);
        }
        this.addSeparator(manager);
    }

    private void addExport(IMenuManager manager) {
        ComponentDescriptor cd = this.getLayoutItem().getComponentDescriptor();
        manager.add((IAction)new ExportAction(this.getShell(), Messages.DESIGN_MENU_DESIGN_MENU_EXPORT_COMPONENT_TEXT, String.valueOf(cd.getIdentifier()) + ".xml", this.getLayoutItem()));
    }

    private Shell getShell() {
        return ((IWorkbenchWindow)this.getServiceLocator().getService("workbenchWindow")).getShell();
    }

    private void addImport(IMenuManager manager) {
        final String oldName = LayoutToolkit.getDisplayName(this.getLayoutItem());
        ImportAction<LayoutItem> ia = new ImportAction<LayoutItem>(this.getShell(), Messages.DESIGN_MENU_DESIGN_MENU_IMPORT_COMPONENT_TEXT, this.getLayoutItem()){

            @Override
            protected void commitObject(LayoutItem li) {
                DesignMenu.this.getLayoutItem().setChanged();
                DesignMenu.this.getLayoutItem().notifyObservers(LayoutNotifaction.create(OperationType.IMPORT, NLS.bind((String)Messages.DESIGN_MENU_IMPORT_NOTIFICATION_TEXT, (Object)LayoutToolkit.getDisplayName(li), (Object)oldName), li));
            }
        };
        manager.add((IAction)ia);
    }

    private void addLayoutItems(IMenuManager manager) {
        this.addAdd(manager);
        this.addCollapse(manager);
        this.addSeparator(manager);
    }

    private void addSeparator(IMenuManager manager) {
        manager.add((IContributionItem)new Separator());
    }

    private void addCollapse(IMenuManager manager) {
        if (this.hasParent()) {
            manager.add((IAction)new RemoveAction(this.getDesignElement()));
        }
    }

    private void addProperties(IMenuManager manager) {
        manager.add((IAction)new ComponentPropertiesAction(this.getServiceLocator(), this.getDesignElement(), true));
    }

    private void addAssignCompomentMenu(IMenuManager manager) {
        manager.add((IContributionItem)new AssignComponentMenu(this.getDesignElement(), this.getServiceLocator()));
        this.addSeparator(manager);
    }

    private void addAdd(IMenuManager manager) {
        if (this.hasParent()) {
            manager.add((IAction)new InsertAction(InsertAction.POSITION.BEFORE, this.getDesignElement()));
            manager.add((IAction)new InsertAction(InsertAction.POSITION.AFTER, this.getDesignElement()));
        }
    }

    private boolean hasParent() {
        return this.getDesignElement().getParentElement() != null;
    }

    private boolean hasComponentDescriptor() {
        return this.getLayoutItem().getComponentDescriptor() != null;
    }

    public static void show(Control control, IDesignElement designElement, IServiceLocator serviceLocator) {
        if (designElement != null && serviceLocator != null) {
            DesignMenu menuManager = new DesignMenu(designElement, serviceLocator);
            Menu oldMenu = control.getMenu();
            if (oldMenu != null && !oldMenu.isDisposed()) {
                oldMenu.dispose();
            }
            control.setMenu(menuManager.createContextMenu(control));
        }
    }
}

