/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.settings.convertors;

import java.awt.Image;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.IntrospectionException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.beans.beancontext.BeanContext;
import java.beans.beancontext.BeanContextChild;
import java.beans.beancontext.BeanContextMembershipEvent;
import java.beans.beancontext.BeanContextMembershipListener;
import java.beans.beancontext.BeanContextProxy;
import java.beans.beancontext.BeanContextSupport;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.Icon;
import org.netbeans.modules.settings.convertors.SerialDataConvertor;
import org.netbeans.modules.settings.convertors.XMLSettingsSupport;
import org.openide.actions.ToolsAction;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.loaders.InstanceDataObject;
import org.openide.nodes.BeanChildren;
import org.openide.nodes.BeanNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.SharedClassObject;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;

public final class SerialDataNode
extends DataNode {
    private PropL propertyChangeListener = null;
    private boolean noBeanInfo = false;
    private final SerialDataConvertor convertor;
    private WeakReference<Object> settingInstance = new WeakReference<Object>(null);
    private boolean isNameChanged = false;
    private final Boolean isAfterNodeConstruction;
    static final String ATTR_DISPLAY_NAME = "SerialDataNode_DisplayName";
    private boolean notifyResolvePropertyChange = true;

    public SerialDataNode(DataObject dataObject) {
        this(null, dataObject, Boolean.FALSE.equals(dataObject.getPrimaryFile().getAttribute("beaninfo")));
    }

    public SerialDataNode(SerialDataConvertor serialDataConvertor) {
        this(serialDataConvertor, serialDataConvertor.getDataObject(), Boolean.FALSE.equals(serialDataConvertor.getDataObject().getPrimaryFile().getAttribute("beaninfo")));
    }

    private SerialDataNode(SerialDataConvertor serialDataConvertor, DataObject dataObject, boolean bl) {
        super(dataObject, SerialDataNode.getChildren(dataObject, bl));
        this.convertor = serialDataConvertor;
        this.noBeanInfo = bl;
        this.isAfterNodeConstruction = Boolean.TRUE;
    }

    private static Children getChildren(DataObject dataObject, boolean bl) {
        if (bl) {
            return Children.LEAF;
        }
        InstanceCookie instanceCookie = (InstanceCookie)dataObject.getCookie(InstanceCookie.class);
        if (instanceCookie == null) {
            return Children.LEAF;
        }
        try {
            Class clazz = instanceCookie.instanceClass();
            if (BeanContext.class.isAssignableFrom(clazz) || BeanContextProxy.class.isAssignableFrom(clazz)) {
                return new InstanceChildren();
            }
            return Children.LEAF;
        }
        catch (Exception exception) {
            return Children.LEAF;
        }
    }

    private InstanceDataObject i() {
        return (InstanceDataObject)this.getDataObject();
    }

    private InstanceCookie.Of ic() {
        return (InstanceCookie.Of)this.getDataObject().getCookie(InstanceCookie.Of.class);
    }

    private SerialDataConvertor getConvertor() {
        return this.convertor;
    }

    private Object getSettingInstance() {
        return this.settingInstance.get();
    }

    private void setSettingsInstance(Object object) {
        if (object == this.settingInstance.get()) {
            return;
        }
        this.isNameChanged = false;
        this.settingInstance = new WeakReference<Object>(object);
    }

    public Image getIcon(int n) {
        if (this.noBeanInfo) {
            return super.getIcon(n);
        }
        Image image = this.initIcon(n);
        if (image == null) {
            image = super.getIcon(n);
        }
        try {
            DataObject dataObject = this.getDataObject();
            return dataObject.getPrimaryFile().getFileSystem().getStatus().annotateIcon(image, n, dataObject.files());
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            return image;
        }
    }

    public Image getOpenedIcon(int n) {
        return this.getIcon(n);
    }

    public String getHtmlDisplayName() {
        return null;
    }

    private void resolvePropertyChange() {
        SerialDataConvertor serialDataConvertor;
        if (this.propertyChangeListener != null && this.propertyChangeListener.getChangeAndReset()) {
            return;
        }
        if (this.notifyResolvePropertyChange && this.propertyChangeListener != null) {
            this.notifyResolvePropertyChange = false;
            XMLSettingsSupport.err.warning("Warning: no PropertyChangeEvent fired from settings stored in " + this.getDataObject());
        }
        if ((serialDataConvertor = this.getConvertor()) != null) {
            serialDataConvertor.handleUnfiredChange();
        }
    }

    private void initPList(Object object, BeanInfo beanInfo, BeanNode.Descriptor descriptor) {
        EventSetDescriptor[] eventSetDescriptorArray = beanInfo.getEventSetDescriptors();
        try {
            Method method = null;
            for (int i = 0; eventSetDescriptorArray != null && i < eventSetDescriptorArray.length; ++i) {
                method = eventSetDescriptorArray[i].getAddListenerMethod();
                if (method == null || !method.getName().equals("addPropertyChangeListener")) continue;
                this.propertyChangeListener = new PropL(this.createSupportedPropertyNames(descriptor));
                method.invoke(object, WeakListeners.propertyChange((PropertyChangeListener)this.propertyChangeListener, (Object)object));
                this.setSettingsInstance(object);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Collection<String> createSupportedPropertyNames(BeanNode.Descriptor descriptor) {
        Node.Property property;
        int n;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (descriptor.property != null) {
            for (n = 0; n < descriptor.property.length; ++n) {
                property = descriptor.property[n];
                arrayList.add(property.getName());
            }
        }
        if (descriptor.expert != null) {
            for (n = 0; n < descriptor.expert.length; ++n) {
                property = descriptor.property[n];
                arrayList.add(property.getName());
            }
        }
        return arrayList;
    }

    private Image initIcon(int n) {
        Image image = null;
        try {
            BeanInfo beanInfo;
            SystemAction systemAction;
            InstanceCookie.Of of = this.ic();
            if (of == null) {
                return null;
            }
            Class clazz = of.instanceClass();
            String string = clazz.getName();
            if (string.equals("javax.swing.JSeparator") || string.equals("javax.swing.JToolBar$Separator")) {
                systemAction = Class.forName("javax.swing.JSeparator");
                beanInfo = Utilities.getBeanInfo(systemAction);
            } else {
                beanInfo = Utilities.getBeanInfo((Class)clazz);
            }
            if (beanInfo != null) {
                image = beanInfo.getIcon(n);
            }
            if (SystemAction.class.isAssignableFrom(clazz)) {
                Icon icon;
                systemAction = SystemAction.get(clazz.asSubclass(SystemAction.class));
                if (image == null && (icon = systemAction.getIcon()) != null) {
                    image = ImageUtilities.icon2Image((Icon)icon);
                }
            }
        }
        catch (Exception exception) {
            Logger.getLogger(SerialDataNode.class.getName()).log(Level.WARNING, null, exception);
        }
        return image;
    }

    private String getNameForBean() {
        try {
            Method method;
            InstanceCookie.Of of = this.ic();
            if (of == null) {
                return NbBundle.getMessage(SerialDataNode.class, (String)"LBL_BrokenSettings");
            }
            Class clazz = of.instanceClass();
            Class[] classArray = new Class[]{};
            try {
                method = clazz.getMethod("getName", classArray);
                if (method.getReturnType() != String.class) {
                    throw new NoSuchMethodException();
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                try {
                    method = clazz.getMethod("getDisplayName", classArray);
                    if (method.getReturnType() != String.class) {
                        throw new NoSuchMethodException();
                    }
                }
                catch (NoSuchMethodException noSuchMethodException2) {
                    return null;
                }
            }
            Object object = of.instanceCreate();
            this.setSettingsInstance(object);
            return (String)method.invoke(object, new Object[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private Method getDeclaredSetter() {
        Method method = null;
        try {
            InstanceCookie.Of of = this.ic();
            if (of == null) {
                return null;
            }
            Class clazz = of.instanceClass();
            Class[] classArray = new Class[]{String.class};
            try {
                method = clazz.getMethod("setName", classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                method = clazz.getMethod("setDisplayName", classArray);
            }
            if (!Modifier.isPublic(method.getModifiers())) {
                method = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return method;
    }

    public void setName(String string) {
        String string2 = this.getName();
        if (string2 != null && string2.equals(string)) {
            return;
        }
        InstanceCookie.Of of = this.ic();
        if (of == null) {
            return;
        }
        Method method = this.getDeclaredSetter();
        if (method != null) {
            try {
                Object object = of.instanceCreate();
                this.setSettingsInstance(object);
                method.invoke(object, string);
                this.isNameChanged = true;
                this.getDataObject().getPrimaryFile().setAttribute(ATTR_DISPLAY_NAME, (Object)string);
                this.resolvePropertyChange();
                return;
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                Exceptions.printStackTrace((Throwable)classNotFoundException);
            }
            catch (IllegalAccessException illegalAccessException) {
                Exceptions.attachLocalizedMessage((Throwable)illegalAccessException, (String)this.getDataObject().toString());
                Exceptions.printStackTrace((Throwable)illegalAccessException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Exceptions.attachLocalizedMessage((Throwable)illegalArgumentException, (String)this.getDataObject().toString());
                Exceptions.printStackTrace((Throwable)illegalArgumentException);
            }
            catch (InvocationTargetException invocationTargetException) {
                Exceptions.attachLocalizedMessage((Throwable)invocationTargetException, (String)this.getDataObject().toString());
                Exceptions.printStackTrace((Throwable)invocationTargetException);
            }
        }
    }

    public String getName() {
        if (this.isAfterNodeConstruction == null) {
            return super.getName();
        }
        return this.getDisplayName();
    }

    public String getDisplayName() {
        String string;
        Object object = this.getSettingInstance();
        if (object != null && this.isNameChanged && (string = this.getNameForBean()) != null) {
            return string;
        }
        string = (String)this.getDataObject().getPrimaryFile().getAttribute(ATTR_DISPLAY_NAME);
        if (string == null) {
            try {
                String string2 = "\b";
                FileSystem.Status status = this.getDataObject().getPrimaryFile().getFileSystem().getStatus();
                string = status.annotateName(string2, this.getDataObject().files());
                if (string.indexOf(string2) < 0) {
                    return string;
                }
                string = this.getNameForBean();
                string = string != null ? status.annotateName(string, this.getDataObject().files()) : status.annotateName(this.getDataObject().getName(), this.getDataObject().files());
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                // empty catch block
            }
        }
        return string;
    }

    protected Sheet createSheet() {
        Sheet sheet = new Sheet();
        InstanceCookie.Of of = this.ic();
        if (of != null) {
            try {
                Class clazz = of.instanceClass();
                Object object = of.instanceCreate();
                BeanInfo beanInfo = Utilities.getBeanInfo((Class)clazz);
                BeanNode.Descriptor descriptor = BeanNode.computeProperties((Object)object, (BeanInfo)beanInfo);
                BeanDescriptor beanDescriptor = beanInfo.getBeanDescriptor();
                this.initPList(object, beanInfo, descriptor);
                sheet.put(this.createPropertiesSet(descriptor, beanDescriptor));
                if (descriptor.expert != null && descriptor.expert.length != 0) {
                    sheet.put(this.createExpertSet(descriptor, beanDescriptor));
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                Logger.getLogger(SerialDataNode.class.getName()).log(Level.WARNING, null, classNotFoundException);
            }
            catch (IOException iOException) {
                Logger.getLogger(SerialDataNode.class.getName()).log(Level.WARNING, null, iOException);
            }
            catch (IntrospectionException introspectionException) {
                Logger.getLogger(SerialDataNode.class.getName()).log(Level.WARNING, null, introspectionException);
            }
        }
        return sheet;
    }

    private Sheet.Set createExpertSet(BeanNode.Descriptor descriptor, BeanDescriptor beanDescriptor) {
        Object object;
        Sheet.Set set = Sheet.createExpertSet();
        SerialDataNode.convertProps(set, descriptor.expert, this);
        if (beanDescriptor != null && (object = beanDescriptor.getValue("expertHelpID")) != null && object instanceof String) {
            set.setValue("helpID", object);
        }
        return set;
    }

    private Sheet.Set createPropertiesSet(BeanNode.Descriptor descriptor, BeanDescriptor beanDescriptor) {
        Object object;
        Sheet.Set set = Sheet.createPropertiesSet();
        if (descriptor.property != null) {
            SerialDataNode.convertProps(set, descriptor.property, this);
        }
        if (beanDescriptor != null && (object = beanDescriptor.getValue("propertiesHelpID")) != null && object instanceof String) {
            set.setValue("helpID", object);
        }
        return set;
    }

    private static final void convertProps(Sheet.Set set, Node.Property<?>[] propertyArray, SerialDataNode serialDataNode) {
        for (int i = 0; i < propertyArray.length; ++i) {
            if (propertyArray[i] instanceof Node.IndexedProperty) {
                set.put((Node.Property)new I((Node.IndexedProperty)propertyArray[i], serialDataNode));
                continue;
            }
            set.put((Node.Property)new P(propertyArray[i], serialDataNode));
        }
    }

    public boolean canRename() {
        return this.getDeclaredSetter() != null;
    }

    public boolean canDestroy() {
        try {
            InstanceCookie.Of of = this.ic();
            if (of == null) {
                return true;
            }
            Class clazz = of.instanceClass();
            return !SharedClassObject.class.isAssignableFrom(clazz);
        }
        catch (Exception exception) {
            return true;
        }
    }

    public boolean canCut() {
        try {
            InstanceCookie.Of of = this.ic();
            if (of == null) {
                return false;
            }
            Class clazz = of.instanceClass();
            return !SharedClassObject.class.isAssignableFrom(clazz);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean canCopy() {
        try {
            InstanceCookie.Of of = this.ic();
            if (of == null) {
                return false;
            }
            Class clazz = of.instanceClass();
            return !SharedClassObject.class.isAssignableFrom(clazz);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String getShortDescription() {
        if (this.noBeanInfo) {
            return super.getShortDescription();
        }
        try {
            InstanceCookie.Of of = this.ic();
            if (of == null) {
                return this.getDataObject().getPrimaryFile().toString();
            }
            Class clazz = of.instanceClass();
            BeanDescriptor beanDescriptor = Utilities.getBeanInfo((Class)clazz).getBeanDescriptor();
            String string = beanDescriptor.getShortDescription();
            return string.equals(beanDescriptor.getDisplayName()) ? this.getDisplayName() : string;
        }
        catch (Exception exception) {
            return super.getShortDescription();
        }
    }

    public Action getPreferredAction() {
        return null;
    }

    private final class PropL
    implements PropertyChangeListener {
        private Collection<String> supportedPropertyNames;
        private boolean isChanged = false;

        PropL(Collection<String> collection) {
            this.supportedPropertyNames = collection;
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.isChanged = true;
            String string = propertyChangeEvent.getPropertyName();
            if (this.isSupportedName(string)) {
                SerialDataNode.this.firePropertyChange(string, propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
                if (string.equals("name")) {
                    SerialDataNode.this.isNameChanged = true;
                    SerialDataNode.this.fireDisplayNameChange(null, null);
                } else if (string.equals("displayName")) {
                    SerialDataNode.this.isNameChanged = true;
                }
            }
        }

        private boolean isSupportedName(String string) {
            return string != null && this.supportedPropertyNames.contains(string);
        }

        public boolean getChangeAndReset() {
            boolean bl = this.isChanged;
            this.isChanged = false;
            return bl;
        }
    }

    private static class BeanContextNode
    extends BeanNode<Object> {
        public BeanContextNode(Object object, SerialDataNode serialDataNode) throws IntrospectionException {
            super(object, BeanContextNode.getChildren(object, serialDataNode));
            this.changeSheet(this.getSheet(), serialDataNode);
        }

        private void changeSheet(Sheet sheet, SerialDataNode serialDataNode) {
            Sheet.Set set = sheet.get("properties");
            if (set != null) {
                SerialDataNode.convertProps(set, set.getProperties(), serialDataNode);
            }
            if ((set = sheet.get("expert")) != null) {
                SerialDataNode.convertProps(set, set.getProperties(), serialDataNode);
            }
        }

        private static Children getChildren(Object object, SerialDataNode serialDataNode) {
            BeanContextChild beanContextChild;
            if (object instanceof BeanContext) {
                return new BeanChildren((BeanContext)object, (BeanChildren.Factory)new BeanFactoryImpl(serialDataNode));
            }
            if (object instanceof BeanContextProxy && (beanContextChild = ((BeanContextProxy)object).getBeanContextProxy()) instanceof BeanContext) {
                return new BeanChildren((BeanContext)beanContextChild, (BeanChildren.Factory)new BeanFactoryImpl(serialDataNode));
            }
            return Children.LEAF;
        }

        public boolean canDestroy() {
            return false;
        }

        public Action[] getActions(boolean bl) {
            return BeanContextNode.removeActions(super.getActions(bl), new Action[]{SystemAction.get(ToolsAction.class)});
        }

        private static Action[] removeActions(Action[] actionArray, Action[] actionArray2) {
            Action[] actionArray3 = actionArray;
            List<Action> list = Arrays.asList(actionArray);
            for (int i = 0; i < actionArray2.length; ++i) {
                Action action = actionArray2[i];
                if (!list.contains(action)) continue;
                list = new ArrayList<Action>(list);
                list.remove(action);
                actionArray3 = list.toArray(new Action[0]);
            }
            return actionArray3;
        }
    }

    private static class BeanFactoryImpl
    implements BeanChildren.Factory {
        SerialDataNode task;

        public BeanFactoryImpl(SerialDataNode serialDataNode) {
            this.task = serialDataNode;
        }

        public Node createNode(Object object) throws IntrospectionException {
            return new BeanContextNode(object, this.task);
        }
    }

    private static final class InstanceChildren
    extends Children.Keys {
        SerialDataNode task;
        DataObject dobj;
        Object bean;
        ContextL contextL = null;

        protected void addNotify() {
            super.addNotify();
            this.task = (SerialDataNode)this.getNode();
            this.dobj = this.task.getDataObject();
            this.contextL = new ContextL(this);
            this.init();
        }

        protected void removeNotify() {
            if (this.contextL != null && this.bean != null) {
                ((BeanContext)this.bean).removeBeanContextMembershipListener(this.contextL);
            }
            this.contextL = null;
            this.setKeys(Collections.emptySet());
        }

        private void init() {
            try {
                InstanceCookie instanceCookie = (InstanceCookie)this.dobj.getCookie(InstanceCookie.class);
                if (instanceCookie == null) {
                    this.bean = null;
                    return;
                }
                Class clazz = instanceCookie.instanceClass();
                this.bean = BeanContext.class.isAssignableFrom(clazz) ? instanceCookie.instanceCreate() : (BeanContextProxy.class.isAssignableFrom(clazz) ? ((BeanContextProxy)instanceCookie.instanceCreate()).getBeanContextProxy() : null);
            }
            catch (Exception exception) {
                this.bean = null;
                Exceptions.printStackTrace((Throwable)exception);
            }
            if (this.bean != null) {
                ((BeanContext)this.bean).addBeanContextMembershipListener(this.contextL);
            }
            this.updateKeys();
        }

        private void updateKeys() {
            if (this.bean == null) {
                this.setKeys(Collections.emptySet());
            } else {
                this.setKeys(((BeanContext)this.bean).toArray());
            }
        }

        protected Node[] createNodes(Object object) {
            Object object2 = this.bean;
            if (this.bean == null) {
                return new Node[0];
            }
            try {
                BeanContextSupport beanContextSupport;
                if (object instanceof BeanContextSupport && ((BeanContext)object2).contains((beanContextSupport = (BeanContextSupport)object).getBeanContextPeer())) {
                    return new Node[0];
                }
                return new Node[]{new BeanContextNode(object, this.task)};
            }
            catch (IntrospectionException introspectionException) {
                return new Node[0];
            }
        }

        private static final class ContextL
        implements BeanContextMembershipListener {
            private final Reference<InstanceChildren> ref;

            ContextL(InstanceChildren instanceChildren) {
                this.ref = new WeakReference<InstanceChildren>(instanceChildren);
            }

            @Override
            public void childrenAdded(BeanContextMembershipEvent beanContextMembershipEvent) {
                InstanceChildren instanceChildren = this.ref.get();
                if (instanceChildren != null) {
                    instanceChildren.updateKeys();
                }
            }

            @Override
            public void childrenRemoved(BeanContextMembershipEvent beanContextMembershipEvent) {
                InstanceChildren instanceChildren = this.ref.get();
                if (instanceChildren != null) {
                    instanceChildren.updateKeys();
                }
            }
        }
    }

    private static final class I
    extends Node.IndexedProperty {
        private Node.IndexedProperty del;
        private SerialDataNode t;

        public I(Node.IndexedProperty indexedProperty, SerialDataNode serialDataNode) {
            super(indexedProperty.getValueType(), indexedProperty.getElementType());
            this.del = indexedProperty;
            this.t = serialDataNode;
        }

        public void setName(String string) {
            this.del.setName(string);
        }

        public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
            this.del.restoreDefaultValue();
        }

        public void setValue(String string, Object object) {
            this.del.setValue(string, object);
        }

        public boolean supportsDefaultValue() {
            return this.del.supportsDefaultValue();
        }

        public boolean canRead() {
            return this.del.canRead();
        }

        public PropertyEditor getPropertyEditor() {
            return this.del.getPropertyEditor();
        }

        public boolean isHidden() {
            return this.del.isHidden();
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.del.getValue();
        }

        public void setExpert(boolean bl) {
            this.del.setExpert(bl);
        }

        public void setValue(Object object) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            this.del.setValue(object);
            this.t.resolvePropertyChange();
        }

        public void setShortDescription(String string) {
            this.del.setShortDescription(string);
        }

        public boolean isExpert() {
            return this.del.isExpert();
        }

        public boolean canWrite() {
            return this.del.canWrite();
        }

        public Class getValueType() {
            return this.del.getValueType();
        }

        public String getDisplayName() {
            return this.del.getDisplayName();
        }

        public Enumeration<String> attributeNames() {
            return this.del.attributeNames();
        }

        public String getShortDescription() {
            return this.del.getShortDescription();
        }

        public String getName() {
            return this.del.getName();
        }

        public void setHidden(boolean bl) {
            this.del.setHidden(bl);
        }

        public void setDisplayName(String string) {
            this.del.setDisplayName(string);
        }

        public boolean isPreferred() {
            return this.del.isPreferred();
        }

        public Object getValue(String string) {
            return this.del.getValue(string);
        }

        public void setPreferred(boolean bl) {
            this.del.setPreferred(bl);
        }

        public boolean canIndexedRead() {
            return this.del.canIndexedRead();
        }

        public Class getElementType() {
            return this.del.getElementType();
        }

        public Object getIndexedValue(int n) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            return this.del.getIndexedValue(n);
        }

        public boolean canIndexedWrite() {
            return this.del.canIndexedWrite();
        }

        public void setIndexedValue(int n, Object object) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            this.del.setIndexedValue(n, object);
            this.t.resolvePropertyChange();
        }

        public PropertyEditor getIndexedPropertyEditor() {
            return this.del.getIndexedPropertyEditor();
        }
    }

    private static final class P
    extends Node.Property {
        private Node.Property del;
        private SerialDataNode t;

        public P(Node.Property property, SerialDataNode serialDataNode) {
            super(property.getValueType());
            this.del = property;
            this.t = serialDataNode;
        }

        public void setName(String string) {
            this.del.setName(string);
        }

        public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
            this.del.restoreDefaultValue();
        }

        public void setValue(String string, Object object) {
            this.del.setValue(string, object);
        }

        public boolean supportsDefaultValue() {
            return this.del.supportsDefaultValue();
        }

        public boolean canRead() {
            return this.del.canRead();
        }

        public PropertyEditor getPropertyEditor() {
            return this.del.getPropertyEditor();
        }

        public boolean isHidden() {
            return this.del.isHidden();
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.del.getValue();
        }

        public void setExpert(boolean bl) {
            this.del.setExpert(bl);
        }

        public void setValue(Object object) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            this.del.setValue(object);
            this.t.resolvePropertyChange();
        }

        public void setShortDescription(String string) {
            this.del.setShortDescription(string);
        }

        public boolean isExpert() {
            return this.del.isExpert();
        }

        public boolean canWrite() {
            return this.del.canWrite();
        }

        public Class getValueType() {
            return this.del.getValueType();
        }

        public String getDisplayName() {
            return this.del.getDisplayName();
        }

        public Enumeration<String> attributeNames() {
            return this.del.attributeNames();
        }

        public String getShortDescription() {
            return this.del.getShortDescription();
        }

        public String getName() {
            return this.del.getName();
        }

        public void setHidden(boolean bl) {
            this.del.setHidden(bl);
        }

        public void setDisplayName(String string) {
            this.del.setDisplayName(string);
        }

        public boolean isPreferred() {
            return this.del.isPreferred();
        }

        public Object getValue(String string) {
            return this.del.getValue(string);
        }

        public void setPreferred(boolean bl) {
            this.del.setPreferred(bl);
        }
    }
}

