/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.graph.layout;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.netbeans.api.visual.graph.layout.GraphLayout;
import org.netbeans.api.visual.graph.layout.TreeGraphLayoutAlignment;
import org.netbeans.api.visual.graph.layout.UniversalGraph;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.visual.graph.layout.TreeGraphLayout;

public final class TreeGraphLayout<N, E>
extends GraphLayout<N, E> {
    private int originX;
    private int originY;
    private int verticalGap;
    private int horizontalGap;
    private boolean vertical;
    private boolean minimizeGap;
    private TreeGraphLayoutAlignment alignment;
    private N rootNode;

    public TreeGraphLayout(int n, int n2, int n3, int n4, boolean bl) {
        this.originX = n;
        this.originY = n2;
        this.verticalGap = n3;
        this.horizontalGap = n4;
        this.vertical = bl;
        this.minimizeGap = false;
        this.alignment = TreeGraphLayoutAlignment.TOP;
    }

    public TreeGraphLayout(int n, int n2, int n3, int n4, boolean bl, boolean bl2, TreeGraphLayoutAlignment treeGraphLayoutAlignment) {
        this(n, n2, n3, n4, bl);
        this.minimizeGap = bl2;
        this.alignment = treeGraphLayoutAlignment;
    }

    public void setRootNode(N n) {
        this.rootNode = n;
    }

    public void setProperties(int n, int n2, int n3, int n4, boolean bl) {
        if (bl) {
            this.originX = n;
            this.originY = n2;
            this.verticalGap = n3;
            this.horizontalGap = n4;
        } else {
            this.originX = n2;
            this.originY = n;
            this.verticalGap = n4;
            this.horizontalGap = n3;
        }
        this.vertical = bl;
        this.minimizeGap = false;
        this.alignment = TreeGraphLayoutAlignment.TOP;
    }

    public void setProperties(int n, int n2, int n3, int n4, boolean bl, boolean bl2, TreeGraphLayoutAlignment treeGraphLayoutAlignment) {
        this.setProperties(n, n2, n3, n4, bl);
        this.minimizeGap = bl2;
        this.alignment = treeGraphLayoutAlignment;
    }

    @Override
    protected void performGraphLayout(UniversalGraph<N, E> universalGraph) {
        if (this.rootNode == null) {
            return;
        }
        Collection<N> collection = universalGraph.getNodes();
        if (!collection.contains(this.rootNode)) {
            return;
        }
        ArrayList<N> arrayList = new ArrayList<N>(collection);
        HashSet hashSet = new HashSet();
        Node node = new Node(universalGraph, this.rootNode, hashSet);
        arrayList.removeAll(hashSet);
        Map map = node.getMaxSpaceForEveryLevel(universalGraph);
        List list = node.layout(this.originX, this.originY, map, 0);
        int n = Integer.MIN_VALUE;
        for (Object object : list) {
            if (((Node.LeftRight)object).getLeft() >= this.originX || this.originX - ((Node.LeftRight)object).getLeft() <= n) continue;
            n = this.originX - ((Node.LeftRight)object).getLeft();
        }
        if (n == Integer.MIN_VALUE) {
            n = 0;
        }
        if (!this.vertical) {
            node.invert(n);
        } else {
            node.relativeBoundsCorrectionX(n);
        }
        HashMap hashMap = new HashMap();
        node.upload(hashMap);
        for (Object object : arrayList) {
            Point point = new Point();
            hashMap.put(object, point);
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            this.setResolvedNodeLocation(universalGraph, entry.getKey(), (Point)entry.getValue());
        }
    }

    @Override
    protected void performNodesLayout(UniversalGraph<N, E> universalGraph, Collection<N> collection) {
        throw new UnsupportedOperationException();
    }

    private class Node {
        private N node;
        private ArrayList<Node> children;
        private Rectangle relativeBounds;
        private int space;
        private Point point;

        private Node(UniversalGraph<N, E> universalGraph, N n, HashSet<N> hashSet) {
            this.node = n;
            hashSet.add(n);
            this.children = new ArrayList();
            for (Object e : universalGraph.findNodeEdges(n, true, false)) {
                Object n2 = universalGraph.getEdgeTarget(e);
                if (n2 == null || hashSet.contains(n2)) continue;
                this.children.add(new Node(universalGraph, n2, hashSet));
            }
        }

        private Map<Integer, Integer> getMaxSpaceForEveryLevel(UniversalGraph<N, E> universalGraph) {
            HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
            this.calculateMaxSpace(universalGraph, hashMap, 0);
            return hashMap;
        }

        private Map<Integer, Integer> calculateMaxSpace(UniversalGraph<N, E> universalGraph, Map<Integer, Integer> map, int n) {
            Widget widget = universalGraph.getScene().findWidget(this.node);
            widget.getLayout().layout(widget);
            this.relativeBounds = widget.getPreferredBounds();
            this.space = TreeGraphLayout.this.vertical ? this.relativeBounds.height : this.relativeBounds.width;
            if (map.get(n) != null) {
                if (map.get(n) < this.space) {
                    map.put(n, this.space);
                }
            } else {
                map.put(n, this.space);
            }
            ++n;
            for (Node node : this.children) {
                node.calculateMaxSpace(universalGraph, map, n);
            }
            return map;
        }

        /*
         * Could not resolve type clashes
         */
        private List<org.netbeans.modules.visual.graph.layout.TreeGraphLayout$Node.LeftRight> layout(int n, int n2, Map<Integer, Integer> map, int n3) {
            int n4;
            int n5;
            List<Object> list = null;
            if (this.children.size() == 0) {
                list = new ArrayList<LeftRight>();
                n2 = this.doHorizontalPlacementInLevel(n2, map, n3);
                if (TreeGraphLayout.this.vertical) {
                    n2 -= this.relativeBounds.y;
                    list.add(new LeftRight(n, n + this.relativeBounds.width));
                } else {
                    n2 -= this.relativeBounds.x;
                    list.add(new LeftRight(n, n + this.relativeBounds.height));
                }
                this.point = new Point(n, n2);
                return list;
            }
            ++n3;
            for (n5 = 0; n5 < this.children.size(); ++n5) {
                int n6;
                if (n5 == 0) {
                    list = this.children.get(n5).layout(n, n2 + map.get(n3 - 1) + TreeGraphLayout.this.verticalGap, map, n3);
                    continue;
                }
                List<org.netbeans.modules.visual.graph.layout.TreeGraphLayout$Node.LeftRight> list2 = this.children.get(n5).layout(n, n2 + map.get(n3 - 1) + TreeGraphLayout.this.verticalGap, map, n3);
                n4 = list.size();
                int n7 = list2.size();
                int n8 = n7 - n4;
                int n9 = Integer.MIN_VALUE;
                if (TreeGraphLayout.this.minimizeGap) {
                    for (n6 = n4 - 1; n6 >= 0; --n6) {
                        int n10;
                        if (n6 + n8 < 0 || n6 < 0 || (n10 = ((LeftRight)list.get(n6)).right - ((LeftRight)list2.get(n6 + n8)).left) <= n9) continue;
                        n9 = n10;
                    }
                } else {
                    Object object2;
                    n6 = Integer.MIN_VALUE;
                    for (Object object2 : list) {
                        n6 = Math.max(n6, ((LeftRight)object2).right);
                    }
                    int n11 = Integer.MAX_VALUE;
                    object2 = list2.iterator();
                    while (object2.hasNext()) {
                        LeftRight leftRight = (LeftRight)object2.next();
                        n11 = Math.min(n11, leftRight.left);
                    }
                    n9 = n6 - n11;
                }
                if (n9 > Integer.MIN_VALUE) {
                    n6 = n9 + TreeGraphLayout.this.horizontalGap;
                    this.children.get((int)n5).point.x += n6;
                    this.children.get(n5).moveChildrenHorizontally(n6);
                }
                for (LeftRight leftRight : list2) {
                    leftRight.setLeft(leftRight.getLeft() + n9 + TreeGraphLayout.this.horizontalGap);
                    leftRight.setRight(leftRight.getRight() + n9 + TreeGraphLayout.this.horizontalGap);
                }
                for (n6 = n7 - 1; n6 >= 0; --n6) {
                    if (n6 < list2.size() - list.size()) {
                        list.add(0, list2.get(n6));
                        continue;
                    }
                    if (n6 - n8 < 0 || n6 < 0) continue;
                    if (((LeftRight)list.get(n6 - n8)).left > ((LeftRight)list2.get(n6)).left) {
                        ((LeftRight)list.get(n6 - n8)).setLeft(((LeftRight)list2.get(n6)).left);
                    }
                    if (((LeftRight)list.get(n6 - n8)).right >= ((LeftRight)list2.get(n6)).right) continue;
                    ((LeftRight)list.get(n6 - n8)).setRight(((LeftRight)list2.get(n6)).right);
                }
            }
            n5 = this.doHorizontalPlacementInLevel(n2, map, --n3);
            if (TreeGraphLayout.this.minimizeGap) {
                if (TreeGraphLayout.this.vertical) {
                    this.point = new Point((((LeftRight)list.get(list.size() - 1)).right + ((LeftRight)list.get(list.size() - 1)).left) / 2 - this.relativeBounds.width / 2, n5 - this.relativeBounds.y);
                    list.add(new LeftRight(this.point.x, this.point.x + this.relativeBounds.width));
                } else {
                    this.point = new Point((((LeftRight)list.get(list.size() - 1)).right + ((LeftRight)list.get(list.size() - 1)).left) / 2 - this.relativeBounds.height / 2, n5 - this.relativeBounds.x);
                    list.add(new LeftRight(this.point.x, this.point.x + this.relativeBounds.height));
                }
            } else {
                int n12 = Integer.MAX_VALUE;
                n4 = Integer.MIN_VALUE;
                for (LeftRight leftRight : list) {
                    n12 = Math.min(n12, leftRight.left);
                    n4 = Math.max(n4, leftRight.right);
                }
                assert (n12 != Integer.MAX_VALUE) : "whether envelope was empty or it had no valid leftMin value!";
                assert (n4 != Integer.MIN_VALUE) : "whether envelope was empty or it had no vaild rightMin value!";
                if (TreeGraphLayout.this.vertical) {
                    this.point = new Point((n12 + n4) / 2 - this.relativeBounds.width / 2, n5 - this.relativeBounds.y);
                    list.add(new LeftRight(this.point.x, this.point.x + this.relativeBounds.width));
                } else {
                    this.point = new Point((n12 + n4) / 2 - this.relativeBounds.height / 2, n5 - this.relativeBounds.x);
                    list.add(new LeftRight(this.point.x, this.point.x + this.relativeBounds.height));
                }
            }
            return list;
        }

        private void moveChildrenHorizontally(int n) {
            for (Node node : this.children) {
                node.point.x += n;
                node.moveChildrenHorizontally(n);
            }
        }

        private int doHorizontalPlacementInLevel(int n, Map<Integer, Integer> map, int n2) {
            int n3 = 0;
            if (TreeGraphLayout.this.alignment == TreeGraphLayoutAlignment.TOP) {
                n3 = n;
            } else if (TreeGraphLayout.this.alignment == TreeGraphLayoutAlignment.CENTER) {
                n3 = n + (map.get(n2) - this.space) / 2;
            } else if (TreeGraphLayout.this.alignment == TreeGraphLayoutAlignment.BOTTOM) {
                n3 = n + (map.get(n2) - this.space);
            }
            return n3;
        }

        private void invert(int n) {
            int n2 = this.point.x + n;
            this.point.x = this.point.y;
            this.point.y = n2 - this.relativeBounds.y;
            for (Node node : this.children) {
                node.invert(n);
            }
        }

        private void relativeBoundsCorrectionX(int n) {
            this.point.x = this.point.x - this.relativeBounds.x + n;
            for (Node node : this.children) {
                node.relativeBoundsCorrectionX(n);
            }
        }

        private void upload(HashMap<N, Point> hashMap) {
            hashMap.put(this.node, this.point);
            for (Node node : this.children) {
                node.upload(hashMap);
            }
        }

        private class LeftRight {
            private int left;
            private int right;

            public LeftRight(int n, int n2) {
                this.left = n;
                this.right = n2;
            }

            public int getLeft() {
                return this.left;
            }

            public int getRight() {
                return this.right;
            }

            public void setLeft(int n) {
                this.left = n;
            }

            public void setRight(int n) {
                this.right = n;
            }
        }
    }
}

