/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.chart.model;

import com.jrockit.mc.common.unit.UnitDescriptor;
import com.jrockit.mc.flightrecorder.ui.components.chart.model.FLRChartDescriptor;
import com.jrockit.mc.flightrecorder.ui.components.chart.model.FLRDescriptorToolkit;
import com.jrockit.mc.flightrecorder.ui.components.chart.model.NavigatorConstants;
import com.jrockit.mc.flightrecorder.ui.components.selection.EventTypeDescriptorRepository;
import com.jrockit.mc.flightrecorder.ui.messages.internal.Messages;
import com.jrockit.mc.greychart.ui.model.DataSeriesDescriptor;
import com.jrockit.mc.greychart.ui.model.XAxisDescriptor;
import com.jrockit.mc.greychart.ui.model.YAxisDescriptor;

public class NavigatorConfigurer {
    public static DataSeriesDescriptor createDataSeriesDescriptor(EventTypeDescriptorRepository repo, boolean operativeSet) {
        DataSeriesDescriptor dsd = new DataSeriesDescriptor();
        dsd.setDrawLine(false);
        dsd.setDescription(Messages.NAVIGATOR_DESCRIPTION_TEXT);
        dsd.setFilled(true);
        dsd.setShowInLegend(true);
        dsd.setStack(true);
        dsd.setStyle(NavigatorConstants.STYLE);
        dsd.setOperativeSet(operativeSet);
        FLRDescriptorToolkit.setYDataSource(dsd, "(duration)");
        if (operativeSet) {
            dsd.setName(Messages.NAVIGATOR_OPERATIVE_SET_NAME);
            dsd.setTopColor(NavigatorConstants.OPERATIVESET_TOPCOLOR);
            dsd.setBottomColor(NavigatorConstants.OPERATIVESET_BOTTOMCOLOR);
        } else {
            dsd.setName(Messages.NAVIGATOR_ALL_EVENTS_NAME);
            dsd.setTopColor(NavigatorConstants.ALLEVENTS_TOPCOLOR);
            dsd.setBottomColor(NavigatorConstants.ALLEVENTS_BOTTOMCOLOR);
        }
        FLRDescriptorToolkit.setEventTypeRepository(dsd, repo);
        return dsd;
    }

    public static FLRChartDescriptor createChartDescriptor() {
        FLRChartDescriptor chartDescriptor = new FLRChartDescriptor();
        XAxisDescriptor xAxis = chartDescriptor.getXAxis();
        YAxisDescriptor leftYAxis = chartDescriptor.getLeftYAxis();
        YAxisDescriptor rightYAxis = chartDescriptor.getRightYAxis();
        UnitDescriptor unit = new UnitDescriptor();
        unit.setProperty("contentType", "number");
        unit.setProperty("displayUnit", "scientificNotation");
        xAxis.setExtrapolateMissingData(true);
        xAxis.setShowGridLines(true);
        xAxis.setShowTickMarks(true);
        xAxis.setVisible(false);
        leftYAxis.setShowGridLines(true);
        leftYAxis.setShowTickMarks(false);
        leftYAxis.setVisible(false);
        leftYAxis.setUnit(unit);
        rightYAxis.setShowGridLines(true);
        rightYAxis.setShowTickMarks(true);
        rightYAxis.setVisible(false);
        rightYAxis.setUnit(unit);
        return chartDescriptor;
    }
}

